function setup() {
    communicate("setup", {})
}

function run(){
    communicate("run", [{
        duration:durationInput.value, 
        title: current_item.title ? current_item.title : get_random_id(), 
        url:current_item.url, 
        categorys: current_item.selectedCategorys, 
        tags: current_item.selectedTags}]);
}

function rerun(data){
    communicate("run", [{
        duration:data.duration, 
        title:data.title, 
        id: data.id, 
        url:data.url, 
        categorys: current_item.selectedCategorys, 
        tags: current_item.selectedTags}]);
}

function saveItem(){
    if (isViewState("ADD")){
        communicate("save-item", [{
            duration: current_item.elapsed_time ? current_item.elapsed_time : '00:00', 
            title: current_item.title ? current_item.title : get_random_id(), 
            url: current_item.url, 
            categorys: current_item.selectedCategorys, 
            tags: current_item.selectedTags}]);
    }

    if (isViewState("EDIT")){
        // alert(current_item.thumbnail)
        //TODO need to make it work - thumbnail is fucking me off
        communicate("update-item", {
            id: current_item.id,
            duration: durationInput.value,
            title: current_item.title ? current_item.title : get_random_id(), 
            url: current_item.url, 
            categorys: current_item.selectedCategorys, 
            tags: current_item.selectedTags,
            thumbnail: current_item.thumbnail});
    }

    create_favourite(current_item)
}

function load(){
    communicate("load-items");
}

function deleteItem(id){
    communicate("del-item", {id})
}

function findVideo(){
    communicate("find-item", {})
}

function switchVideo(item){
    communicate("switch-to", item)
}

function setCurrentTime(){
    communicate("set-current-time")
}

function sendState(){
    communicate("update-state", {
        elapsed_time: current_item.elapsed_time ? current_item.elapsed_time : '00:00',
        title: current_item.title,
        url: current_item.url,
        selectedCategorys: current_item.selectedCategorys,
        selectedTags: current_item.selectedTags
    })
}

function getVolume(){
    communicate("get-volume", {})
}

function communicate(type, data){
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        chrome.tabs.sendMessage(tabs[0].id, {type, data}, function(response){
            if (!window.chrome.runtime.lastError) {
                try{
                    if(response.data){
                        loaded_items = response.data
                        render_item_list(listViewItemList, response.data);
                    }
                    if(response.current_time){
                        updateElapsedTime(response.current_time)
                    }
                    if(response.setup.state){
                        if(response.setup.state){

                            update_ui(response.setup.state)
                        }
                    }
                }
                catch {}
            } else {
                console.log(window.chrome.runtime.lastError)
            }
        });
    });
}
init();