function update_ui(state) {

    updateTitle(state.title);
    updateThumbnail(state.thumbnail)
    updateElapsedTime(state.elapsed_time);
    current_state.domain = state.domain
    
    state.selectedCategorys.forEach(sCat => {
        let cat = current_state.categorys.find((cat) => cat.name == sCat);
        cat.selected = true;
        current_item.selectedCategorys.push(cat.name);
    });

    state.selectedTags.forEach(sTag => {
        let tag = current_state.tags.find((tag) => tag.name == sTag);
        tag.selected = true;
        current_item.selectedTags.push(tag.name);

    });

    render_selection(categoryList, current_state.categorys, selectCategory);    
    render_selection(tagList, current_state.tags, selectTag);  
}

function showAddView() {
    listView.style.display = "none";
    loginView.style.display = "none";
    addView.classList.remove("edit-view");
    addView.classList.add("add-view");
    addView.style.display = "block";
    tabButtonAdd.classList.add("is-active");
    tabButtonList.classList.remove("is-active");
    tabButtonLogin.classList.remove("is-active");
    current_state.viewState = "ADD";
}

function showListView() {
    document.getElementById("item-list").innerHTML = ""
    load();
    addView.style.display = "none";
    loginView.style.display = "none";
    listView.style.display = "block";
    tabButtonAdd.classList.remove("is-active");
    tabButtonLogin.classList.remove("is-active");
    tabButtonList.classList.add("is-active");
    current_state.viewState = "LIST";
}

function showLoginView() {
    document.getElementById("item-list").innerHTML = ""
    addView.style.display = "none";
    listView.style.display = "none";
    loginView.style.display = "block";
    tabButtonAdd.classList.remove("is-active");
    tabButtonList.classList.remove("is-active");
    tabButtonLogin.classList.add("is-active");
    current_state.viewState = "LIST";
}

function showEditView(item) {
    current_item.id = item.id;
    current_item.thumbnail = item.thumbnail;
    listView.style.display = "none";
    loginView.style.display = "none";
    addView.style.display = "block";
    addView.classList.add("edit-view");
    addView.classList.remove("add-view");
    tabButtonAdd.classList.remove("is-active");
    tabButtonLogin.classList.remove("is-active");
    tabButtonList.classList.remove("is-active");
    current_state.viewState = "EDIT";
}

function showCategoryList() {
    if (categoryList.style.display == "block"){
        categoryList.style.display = "none";
        return;
    }
    categoryList.style.display = "block";
}

function showTagList() {
    if (tagList.style.display == "block"){
        tagList.style.display = "none";
        return;
    }
    tagList.style.display = "block";
}

function showRegisterComponent(){
    registerComponent.classList.remove("hide")
    registerComponent.classList.add("show")
    loginComponent.classList.remove("show")
    loginComponent.classList.add("hide")
}

function showLoginComponent(){
    loginComponent.classList.remove("hide")
    loginComponent.classList.add("show")
    registerComponent.classList.remove("show")
    registerComponent.classList.add("hide")
}

function disableLoadPublicDomainButton(){
    listViewHeader.style.display = "none";
}

function selectCategory(category) {
    let found = current_item.selectedCategorys.find((cat) => cat == category.target.innerHTML)
    if (found){
        current_item.selectedCategorys = current_item.selectedCategorys.filter((cat) => cat != found);
        current_state.categorys.forEach((cat) => { 
            if (cat.name == category.target.innerHTML) {
                cat.selected = false;
            } 
        })
        render_selection(categoryList, current_state.categorys, selectCategory);
    } else {
        current_item.selectedCategorys.push(category.target.innerHTML);
        current_state.categorys.forEach((cat) => { 
            if (cat.name == category.target.innerHTML) {
                cat.selected = true;
            } 
        })
        render_selection(categoryList, current_state.categorys, selectCategory);    
    }
    sendState();
}

function selectTag(tag) {
    let found = current_item.selectedTags.find((t) => t == tag.target.innerHTML);
    if (found){
        current_item.selectedTags = current_item.selectedTags.filter((t) => t != found);
        current_state.tags.forEach((t) => { 
            if (t.name == tag.target.innerHTML) {
                t.selected = false;
            } 
        })
        render_selection(tagList, current_state.tags, selectTag);
    } else {
        current_item.selectedTags.push(tag.target.innerHTML);
        current_state.tags.forEach((t) => { 
            if (t.name == tag.target.innerHTML) {
                t.selected = true;
            } 
        })
        render_selection(tagList, current_state.tags, selectTag);    
    }
    sendState();
}