function render_selection(parent, items, cb){
    parent.innerHTML = "";
    items.forEach(item=>{
        let element = document.createElement("div");
        element.id = `item-${item.type}-${item.id}`;
        element.classList.add("list-item");
        item.selected ? element.classList.add("selected") : element.classList.add(item.id % 2 == 0 ? 'even' : 'odd');
        element.innerHTML = item.name;
        element.addEventListener("click", cb);
        parent.appendChild(element);
    })
}

function render_item_list(parent, items){
    parent.innerHTML = "";
    items.forEach(item=>{

        let element = document.createElement("div");
        element.id = `item-${item.id}`;
        element.classList.add("item");

        element.classList.add(item.id % 2 == 0 ? 'even' : 'odd');

        let thumbnail = document.createElement("img");
        thumbnail.src = item.thumbnail;
        thumbnail.classList.add("thumbnail");
        thumbnail.addEventListener("click", function() {switchVideo(item)});

        let infoElement = document.createElement("div");
        infoElement.classList.add("info");

        let title = document.createElement("div");
        title.innerHTML = item.title;
        title.addEventListener("click", function() {rerun({duration: item.elapsed_time, title: item.title, url: item.url})});
        title.classList.add("title");
        infoElement.appendChild(title);

        let infoRow = document.createElement("div");
        infoRow.classList.add("info-row");

        if( item.categorys ) {
            item.categorys.forEach(category => {
                let categoryElement = document.createElement("div");
                categoryElement.innerHTML = category;
                categoryElement.classList.add("category");
                infoRow.appendChild(categoryElement);
            });
        }
        if( item.tags ) {
            item.tags.forEach(tag => {
                let tagElement = document.createElement("div");
                tagElement.innerHTML = tag;
                tagElement.classList.add("tag");
                infoRow.appendChild(tagElement);
            });
        }

        infoElement.appendChild(infoRow)

        let spanDuration = document.createElement("span");
        spanDuration.innerHTML = item.elapsed_time;
        spanDuration.classList.add("duration");
        spanDuration.addEventListener("click", function() { showEditView(item) });

        let delButton = document.createElement("button");
        delButton.innerHTML = "X"
        delButton.classList.add("delete-button");
        delButton.addEventListener("click", function() {deleteItem(item.id) })

        element.appendChild(thumbnail);
        element.appendChild(infoElement);
        element.appendChild(spanDuration);
        element.appendChild(delButton);

        parent.appendChild(element);
    })
}