// const BASE_URL = "https://favourites.njoyporn.com/api/v1";
const BASE_URL = "http://192.168.2.215:8666/api/v1";

async function create_favourite(favourite){
    if(!current_state.verified) return false;
    let xhr = new XMLHttpRequest();
    xhr.open("POST", `${BASE_URL}/favourite`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify(favourite));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
    };
    return false;
}

async function update_favourite(favourite){
    if(!current_state.verified) return false;
    let xhr = new XMLHttpRequest();
    xhr.open("PATCH", `${BASE_URL}/favourite`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify(favourite));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
    };
    return false;
}

async function login(){
    let username = document.getElementById("login-username").value;
    let password = document.getElementById("login-password").value;
    let xhr = new XMLHttpRequest();
    xhr.open("POST", `${BASE_URL}/login`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify({username, password}));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
        current_state.verified = data.success === "authorized";
    };
    return false;
}

async function verify(){
    let xhr = new XMLHttpRequest();
    xhr.open("GET", `${BASE_URL}/login`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify({}));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
        current_state.verified = data.success === "authorized";
        return true;
    };
    return false;
}

async function register(){
    let username = document.getElementById("register-username").value;
    let password = document.getElementById("register-password").value;
    let xhr = new XMLHttpRequest();
    xhr.open("POST", `${BASE_URL}/register`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify({username, password}));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
        console.log(data);
    };
    return false;
}

async function loadPublicDomain(domain){
    let xhr = new XMLHttpRequest();
    xhr.open("GET", `${BASE_URL}/favourite/${domain}`, true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify({}));
    xhr.onload = function() {
        let data = JSON.parse(xhr.responseText);
        disableLoadPublicDomainButton();
        if(data) {
            display_notification("SUCCESS", "Public List Loaded");
            render_item_list(listViewItemList, data)
            return true;
        }
        display_notification("ERROR", "Can'T Load List");
        return false;
    };
    return false;
}